/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.nio.ByteBuffer;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000e\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/exposed/sql/UUIDColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "", "value", "", "nonNullValueToString", "(Ljava/lang/Object;)Ljava/lang/String;", "notNullValueToDB", "(Ljava/lang/Object;)Ljava/lang/Object;", "sqlType", "()Ljava/lang/String;", "Ljava/util/UUID;", "valueFromDB", "(Ljava/lang/Object;)Ljava/util/UUID;", "valueToUUID", "<init>", "()V", "Companion", "exposed-core"})
public final class UUIDColumnType
extends ColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex uuidRegexp = new Regex("[0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12}", RegexOption.IGNORE_CASE);

    public UUIDColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().uuidType();
    }

    @Override
    @NotNull
    public UUID valueFromDB(@NotNull Object value2) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (value2 instanceof UUID) {
            object2 = (UUID)value2;
        } else if (value2 instanceof byte[]) {
            ByteBuffer b = ByteBuffer.wrap((byte[])value2);
            boolean bl = false;
            object2 = new UUID(b.getLong(), b.getLong());
        } else if (value2 instanceof String && uuidRegexp.matches((CharSequence)(object = (CharSequence)value2))) {
            object = UUID.fromString((String)value2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromString(value)");
            object2 = object;
        } else if (value2 instanceof String) {
            object = (String)value2;
            byte[] bl = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"this as java.lang.String).getBytes(charset)");
            ByteBuffer b = ByteBuffer.wrap(bl);
            boolean bl2 = false;
            object2 = new UUID(b.getLong(), b.getLong());
        } else {
            throw new IllegalStateException(("Unexpected value of type UUID: " + value2 + " of " + Reflection.getOrCreateKotlinClass(value2.getClass()).getQualifiedName()).toString());
        }
        return object2;
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return DefaultKt.getCurrentDialect().getDataTypeProvider().uuidToDB(this.valueToUUID(value2));
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return "" + '\'' + this.valueToUUID(value2) + '\'';
    }

    private final UUID valueToUUID(Object value2) {
        UUID uUID;
        Object object = value2;
        if (object instanceof UUID) {
            uUID = (UUID)value2;
        } else if (object instanceof String) {
            UUID uUID2 = UUID.fromString((String)value2);
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"fromString(value)");
            uUID = uUID2;
        } else if (object instanceof byte[]) {
            ByteBuffer it = ByteBuffer.wrap((byte[])value2);
            boolean bl = false;
            uUID = new UUID(it.getLong(), it.getLong());
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Unexpected value of type UUID: ", (Object)value2.getClass().getCanonicalName()).toString());
        }
        return uUID;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/UUIDColumnType$Companion;", "", "Lkotlin/text/Regex;", "uuidRegexp", "Lkotlin/text/Regex;", "<init>", "()V", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

